/**
* \file: UspiTouchInput.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Carplay - USPI Touch Adapter
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
* \author: D. Devarasu /RBEI/ECF3 / dhanasekaran.d@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_USPITOUCHINPUTIMPL_H
#define CARPLAY_USPITOUCHINPUTIMPL_H

#include <memory>
#include <uspi/ITouchFacade.h>
#include <uspi/WaylandFacade.h>

namespace adit { namespace carplay
{

class UspiTouchInputImpl : public uspi::ITouchFacadeCallbacks
{

public:
    UspiTouchInputImpl();
    virtual ~UspiTouchInputImpl();

    bool Initialize(const IConfiguration& inConfig, IInputReceiver& inReceiver, SessionId inSessionId);

    // ITouchFacadeCallbacks
    void onTouch(uspi::TouchEvent inEvent);
    void onTouchError(int inError);
    void onLogging(uspi::UspiLogLevel inLogLevel, const std::string& inLogString);

private:
    IInputReceiver* receiver;
    std::unique_ptr<HIDDigitizer> digitizer;
    std::unique_ptr<uspi::ITouchFacade> mTouchFacade;

    bool verbose;

    void deinitialize();
};

} } /* namespace adit { namespace carplay */

#endif /*CARPLAY_USPITOUCHINPUTIMPL_H*/
